#include <malloc.h>
#include <string.h>
#include <stdlib.h>

#include "guido.h"
#include "strlist.hpp"

strlist::strlist() {
  length=0;
}

strlist::~strlist() {
  int i;
  for (i=1; i<=length; i++) {
    free(table[i-1]);
  }
}

void strlist::clear() {
  int i;
  for (i=1; i<=length; i++) {
    free(table[i-1]);
  }
  length=0;
}

void strlist::addStr(const char *str) {
  char* s = (char *) malloc(sizeof(char)*(strlen(str)+1));
  strcpy(s,str);
  table[length]=s;
  length++;
}

int strlist::findStr(const char *str) {
  int i;
  for (i=1; i<=length; i++) {
    if (strcmp(table[i-1],str)==0)
      return(1);
  }
  return(0);
}

strlist tags11;
strlist tags13;
strlist tags2;

void initStrLists(void) {
  tags11.addStr("\\pageFormat");
  tags11.addStr("\\newPage");
  tags11.addStr("\\systemFormat");
  tags11.addStr("\\newSystem");
  tags11.addStr("\\staffFormat");
  tags11.addStr("\\staff");
  tags11.addStr("\\meter");
  tags11.addStr("\\bar");
  tags11.addStr("\\doubleBar");

  tags13.addStr("\\clef");
  tags13.addStr("\\key");

  tags2.addStr("\\intes");
  tags2.addStr("\\i");
  tags2.addStr("\\cresc");
  tags2.addStr("\\dim");
  tags2.addStr("\\crescBegin");
  tags2.addStr("\\crescEnd");
  tags2.addStr("\\dimBegin");
  tags2.addStr("\\dimEnd");
  tags2.addStr("\\accel");
  tags2.addStr("\\rit");
  tags2.addStr("\\accelBegin");
  tags2.addStr("\\accelEnd");
  tags2.addStr("\\ritBegin");
  tags2.addStr("\\ritEnd");
  tags2.addStr("\\instr");
  tags2.addStr("\\tie");
  tags2.addStr("\\slur");
  tags2.addStr("\\sl");
  tags2.addStr("\\stacc");
  tags2.addStr("\\accent");
  tags2.addStr("\\ten");
  tags2.addStr("\\marcato");
  tags2.addStr("\\trill");
  tags2.addStr("\\mord");
  tags2.addStr("\\turn");
  tags2.addStr("\\trem");
  tags2.addStr("\\fermata");
  tags2.addStr("\\grace");
  tags2.addStr("\\cue");
  tags2.addStr("\\repeatBegin");
  tags2.addStr("\\repeatEnd");
  tags2.addStr("\\oct");
  tags2.addStr("\\beam");
  tags2.addStr("\\bm");
  tags2.addStr("\\beamsAuto");
  tags2.addStr("\\beamsOff");
  tags2.addStr("\\stemsAuto");
  tags2.addStr("\\stemsUp");
  tags2.addStr("\\stemsDown");
  tags2.addStr("\\tactus");
  tags2.addStr("\\text");
  tags2.addStr("\\t");
  tags2.addStr("\\title");
  tags2.addStr("\\composer");
  tags2.addStr("\\mark");
  tags2.addStr("\\label");
  }

/* standard Basic GUIDO tags:
\intens, \i, \cresc, \dim, \crescBegin, \crescEnd, \dimBegin,
\imEnd, \tempo,\accel, \rit, \accelBegin, \accelEnd,
\ritBegin, \ritEnd, \instr, \tie, \slur, \sl, \stacc, \accent,
\ten, \marcato, \trill, \mord, \turn, \trem, \fermata, \grace,
\cue, \repeatBegin, \repeatEnd, \clef, \meter, \key, \oct,
\staff, \beam, \bm,\beamsAuto, \beamsOff, \stemsAuto,
\stemsUp, \stemsDown, \bar, \doubleBar, \tactus, \text, \t,
\title, \composer,\mark, \label.
*/


void freeStrLists(void) {
  tags11.clear();
  tags13.clear();
  tags2.clear();
  }


