#include <string.h>
#include <stdlib.h>

#include "guido.h"
#include "strlist.h"

void strlist_init(strlist *s){
  s->length=0;
}

void strlist_free(strlist *s) {
  int i;
  for (i=1; i<=s->length; i++) {
    free(s->table[i-1]);
  }
}

void strlist_addStr(strlist *s, const char *str) {
  char* t = (char *) malloc(sizeof(char)*(strlen(str)+1));
  strcpy(t,str);
  s->table[s->length]=t;
  s->length++;
}

int strlist_findStr(strlist *s, const char *str) {
  int i;
  for (i=1; i<=s->length; i++) {
    if (strcmp(s->table[i-1],str)==0)
      return(1);
  }
  return(0);
}


void strlist_clear(strlist *s){
  int i;
  for (i=1; i<=s->length; i++) {
    free(s->table[i-1]);
  }
  s->length=0;
}


strlist tags11;
strlist tags13;
strlist tags2;

void initStrLists(void) {
  strlist_addStr(&tags11,"\\pageFormat");
  strlist_addStr(&tags11,"\\newPage");
  strlist_addStr(&tags11,"\\systemFormat");
  strlist_addStr(&tags11,"\\newSystem");
  strlist_addStr(&tags11,"\\staffFormat");
  strlist_addStr(&tags11,"\\staff");
  strlist_addStr(&tags11,"\\meter");
  strlist_addStr(&tags11,"\\bar");
  strlist_addStr(&tags11,"\\doubleBar");

  strlist_addStr(&tags13,"\\clef");
  strlist_addStr(&tags13,"\\key");

  strlist_addStr(&tags2,"\\intes");
  strlist_addStr(&tags2,"\\i");
  strlist_addStr(&tags2,"\\cresc");
  strlist_addStr(&tags2,"\\dim");
  strlist_addStr(&tags2,"\\crescBegin");
  strlist_addStr(&tags2,"\\crescEnd");
  strlist_addStr(&tags2,"\\dimBegin");
  strlist_addStr(&tags2,"\\dimEnd");
  strlist_addStr(&tags2,"\\accel");
  strlist_addStr(&tags2,"\\rit");
  strlist_addStr(&tags2,"\\accelBegin");
  strlist_addStr(&tags2,"\\accelEnd");
  strlist_addStr(&tags2,"\\ritBegin");
  strlist_addStr(&tags2,"\\ritEnd");
  strlist_addStr(&tags2,"\\instr");
  strlist_addStr(&tags2,"\\tie");
  strlist_addStr(&tags2,"\\slur");
  strlist_addStr(&tags2,"\\sl");
  strlist_addStr(&tags2,"\\stacc");
  strlist_addStr(&tags2,"\\accent");
  strlist_addStr(&tags2,"\\ten");
  strlist_addStr(&tags2,"\\marcato");
  strlist_addStr(&tags2,"\\trill");
  strlist_addStr(&tags2,"\\mord");
  strlist_addStr(&tags2,"\\turn");
  strlist_addStr(&tags2,"\\trem");
  strlist_addStr(&tags2,"\\fermata");
  strlist_addStr(&tags2,"\\grace");
  strlist_addStr(&tags2,"\\cue");
  strlist_addStr(&tags2,"\\repeatBegin");
  strlist_addStr(&tags2,"\\repeatEnd");
  strlist_addStr(&tags2,"\\oct");
  strlist_addStr(&tags2,"\\beam");
  strlist_addStr(&tags2,"\\bm");
  strlist_addStr(&tags2,"\\beamsAuto");
  strlist_addStr(&tags2,"\\beamsOff");
  strlist_addStr(&tags2,"\\stemsAuto");
  strlist_addStr(&tags2,"\\stemsUp");
  strlist_addStr(&tags2,"\\stemsDown");
  strlist_addStr(&tags2,"\\tactus");
  strlist_addStr(&tags2,"\\text");
  strlist_addStr(&tags2,"\\t");
  strlist_addStr(&tags2,"\\title");
  strlist_addStr(&tags2,"\\composer");
  strlist_addStr(&tags2,"\\mark");
  strlist_addStr(&tags2,"\\label");
  }

/* standard Basic GUIDO tags:
\intens, \i, \cresc, \dim, \crescBegin, \crescEnd, \dimBegin,
\imEnd, \tempo,\accel, \rit, \accelBegin, \accelEnd,
\ritBegin, \ritEnd, \instr, \tie, \slur, \sl, \stacc, \accent,
\ten, \marcato, \trill, \mord, \turn, \trem, \fermata, \grace,
\cue, \repeatBegin, \repeatEnd, \clef, \meter, \key, \oct,
\staff, \beam, \bm,\beamsAuto, \beamsOff, \stemsAuto,
\stemsUp, \stemsDown, \bar, \doubleBar, \tactus, \text, \t,
\title, \composer,\mark, \label.
*/


void freeStrLists(void) {
  strlist_clear(&tags11);
  strlist_clear(&tags13);
  strlist_clear(&tags2);
  }


