/* naGuido.h */

#include "guido.h"

int na_parseGMNFile(const char* filename);
/* call this function with the name of a GMN file to initiate parsing for this file */

int na_parseGMNFileMode(const char* filename, int mode);
/* DON'T USE THIS FUNCTION - THIS IS PART OF A FUTURE RELEASE */
/*  mode determines which tags / events are filtered
    out. see note.pad for details. */



/* the following functions signal the beginning and end of a GUIDO segment.
   note that even for a single voice segment denoted as [...] in the file
   (without enclosing {...}), these functions are triggered. */
void na_segmInit(void);
void na_segmExit(void);

/* the following functions signal the beginning and end of voice: */
void na_seqInit(void);
void na_seqExit(void);

void na_seqAppendNote(int pc, int oct, int acc, long int durN, long int durD, int dots, 
			long int durPosN, long int durPosD);
/* called after each note that has been completely parsed.
   pc: pitch class, c=0, cis=1, ..., b=h=11, _=rest=-1, empty=-2
  	NOTE: you should use the NOTE_* constants defined in guido.h when comparing/checking
		for specific pitch classes
   oct: octave, as specified in GMN source or carried over from previous note
   acc: accidentals, natural=0, #=1, &=-1, ##=2, &&=-2, ...
	NOTE: pitch class and accidental information are independent, 
	      i.e., c# -> pc=0, acc=1, NOT pc=1, acc=1
   durN, durD: specify duration of note as numerator and denominator of a fraction, 
	*3/4 -> durN=3, durD=4
   dots: dots, e.g., /8 -> durD=1,durN=8,dots=0, /4.. -> durD=1,durN=4,dots=2
	NOTE: duration value and dots are independent, i.e., /4. gives durN=1, durD=4,
	      NOT durN=3, durD=8
   durPosN, durPosD: specify relative time position of the note's beginning 
	as numerator and denominator of a fraction, starting at durPosN=0, durPosD=1;
	e.g., the third note in [c1/4 d/8 e/8] would have durPosD=3, durPosN=8 */

void na_chordInit(long int durPosN, long int durPosD);
/* signals beginning of a chord
   durPosN, durPosD: specify relative time position of the chord's beginning
	as numerator and denominator of a fraction, starting at durPosN=0, durPosD=1; */

void na_chordInitVoice();
/* signals beginning of a new voice within a chord */

void na_seqAppendChord(int voices, long int durN, long int durD, int dots, long int durPosN, long int durPosD);
/* called after a complete chord has been parsed.
   voices: number of voices in the chors, e.g., {c1/8,e,g} -> voices=3
	*3/4 -> durN=3, durD=4
   durN, durD, dots, durPosN, durPosD: as for na_seqAppendNote */

void na_tagStart(char* s, long int no, long int tagno, long int durPosN, long int durPosD);
/* signals that a tag name has been parsed.
   s: name of the tag, including the leading '\'
      NOTE: the string value must be copied if it is to be used after exiting the function
   no: disambiguifiying numerical postfix, if explicitly specified, 0 else
	e.g.: \slurBegin:1 -> no=1, \bar -> no=0
   tagno: reference number of tag, counting starts with 1; this is used to
	match corresponding na_tagStart and na_tagEnd calls
   durPosN, durPosD: specify relative time position were the tag occured
	as numerator and denominator of a fraction, starting at durPosN=0, durPosD=1;
	e.g., the \slur tag in [c1/4 \slur(d/8 e/8)] would have durPosD=1, durPosN=4 */

void na_tagEnd(long int tagno, long int durPosN, long int durPosD,
		long int beforeDurPosN, long int beforeDurPosD);
/* signals end of a tag range.
   tagno: reference number of tag whose range ends here
   durPosN, durPosD: specify relative time position after the last note in the tag
	range as numerator and denominator of a fraction;
	e.g., the call for the \slur tag in [c1/4 \slur(d/8 e/8)] would have
	durPosD=1, durPosN=2
   beforeDurPosN,afterDurPosD: same as durPosN, durPosD, but specify rel. time				position before last note in tag range;
	e.g., the call for the \slur tag in [c1/4 \slur(d/8 e/8)] would have
	beforeDurPosD=3, beforeDurPosN=8 */

void na_tagAdd(long int tagno, int nargs);
/* signals that a tag argument list has been completely parsed
   tagno: reference number of tag whose parameter list has been parsed
   nargs: number of arguments that have been parsed,
	e.g., \intens<mark="mf",val=0.5> -> narg=2
   NOTE: information about the parsed tag arguments have to be accessed
	inside this function, using the na_getTag* functions declared below.
*/


int na_parseError(long int lnr, long int cnr, const char *msg);
/* this function is called if the parser encounters an error.
   lnr and cnr give the line and character number where the parser detected the error,
   msg is an error message string;
   it returns a default value of 0 (other values can be used
   in user implementations to signal, e.g., that the user
   wants to abort parsing) */


/* the following functions have to be called from within na_tagAdd to
   get properties and values of the respective tag's parameters
   n: the number of the tag parameter to be queried, counting starts with 1
      NOTE: na_tagAdd's narg argument gives the number of parameters 
	    and hence the highest valid value of n
   NOTE: if you want ot keep any information returned by these functions, 
	you have to copy it before exiting function na_tagAdd */
char na_getTagArgType(int n);
char* na_getTagArgName(int n);
long int na_getTagArgInt(int n);
T_REAL na_getTagArgFloat(int n);
char* na_getTagArgUnit(int n);
char* na_getTagArgStr(int n);

/* The following functions are no longer supported and have been included
    for backward compatibility reasons only. */
void na_tagIntArg(long int n);
void na_tagFloatArg(double r);
void na_tagStrArg(char *s);

