// changes:
// 03/07/04: jk added unicode transformation support
/* --- debugging tool: --- */

/* to	activate debugging info,
uncomment the following line and recompile:*/
/*#define DEBUG_ON*/

#ifdef DEBUG_ON
#define DEBUG(x) x
#else
#define DEBUG(x)
#endif

/* --- includes: --- */

#ifdef __IBMC__
// Eingebunden fuer read ()
#include "io.h"
#endif

#include "guido.h"
#include "parser_t.c"
extern "C" {
#include "strlist.h"
}

/* --- initialisation, has to be called before
any other gd_* function is called --- */

void gd_init(void) {
	initStrLists();
	/* parser buffer is automatically created
    (once) when gd_parse (yyparse) is called */
}

/* --- cleanup, should be called when parser is
not used any longer --- */

void gd_exit(void) {
	/* free parser buffer */
	// added by jk 
	if( yy_current_buffer )
		yy_delete_buffer(yy_current_buffer);
	freeStrLists();
}

/* --- parser interface: --- */

int parse_mode;

long int lnr;
long int cnr;
long int cmnt_level;

int gd_parse(const char *filename, int mode) {
	int res;
	
	parse_mode = mode;
	
	lnr = 1;
	cnr = 0;
	cmnt_level = 0;
	
	if( !filename )
		return -1; // parse error
	
	{ /// unicode handling
		/// check if "filename" is in unicode format
		long int len = 0;
		char isUnicode = 0;
		FILE *tIn;
		tIn = fopen(filename,"rb");
		if( tIn )
		{
			int c = fgetc( tIn );
			if( c == 0xff || c == 0xfe)
			{
				c = fgetc( tIn );
				if( c == 0xfe || c == 0xff)
				{
					isUnicode = 1;
					/// get file size
					len = 2;
					while( !feof( tIn ) )
					{
						len++;
						fgetc( tIn );
					} // while
				} // if
			}
		} // if
		
		int i;
		unsigned char *content;
		
		if( isUnicode )
		{ 	// read complete file and write again
			content = new unsigned char[len+1];
			if( content )
			{
				rewind( tIn );
				for( i = 0; i < len; i++ )
				{
					content[i] = fgetc(tIn);
				}
			}
			else
			{
				isUnicode = 0;
				return -1; // parse error
			}
		} // if unicode
		if( tIn )
			fclose( tIn );
		if( isUnicode ) // write content back
		{
			tIn = fopen(filename,"wt");
			int i;
			for( i = 0; i < len; i++ )
			{
				// check for {}, [], ...
				// replace ' by ", needed for sibelius import
				/* not needed and wrong!
				if( content[i] == '\'' )
					content[i] = '\"';
					*/
				// write each real char to tIn
				 if( content[i] > 0 &&
				     content[i] <= 0x7f )
					fputc(content[i], tIn);
			}
			fclose( tIn );
			delete [] content;
		} // if unicode
	} // unicode handling
	
	if((yyin= fopen(filename,"r"))==NULL)
	{
		ERROR("Could not open file");
		return(-1);
	}
	
	res = yyparse();
	
	yy_init= 1;
	yy_start= 0;
	yyrestart(yyin);
	fclose(yyin);
	
	return(res);
}


/* --- utility functions: --- */

void gd_fracNorm(long int *a, long int *b) {
	/* normalises fraction a/b */
	long int n, sgn;
	
	if (*b==0)
		return;
		/*
		if ((*a) * (*b) < 0)
		sgn = -1;
		else
		sgn = +1;
	*/
	if( ((*a) > 0 && (*b) > 0) ||
		((*a) < 0 && (*b) < 0) )
		sgn = 1;
    else
        sgn = -1;
    
	*a = labs(*a);
	*b = labs(*b);
	if (*a != 0) {
		for (n=2; n <= *b; n++)
			while (*a % n == 0 && *b % n == 0) {
				*a /= n;
				*b /= n;
			}
	}
	else
		*b = 1;
	*a = sgn * (*a);
}

void gd_fracAdd(long int *a, long int *b,
				const long int c, const long int d) {
	/* sets a/b := a/b+c/d, normalised */
	/* normalise a/b, c/d before using this function */
	if (*b==0 || d==0)
		return;
	
	if (*b == d) {
		*a += c;
    }
	else {
		*a = (*a) *d + c* (*b);
		*b = (*b) *d;
    }
	gd_fracNorm(a,b);
}


int gd_fracCmp(long int a, long int b,
			   long int c, long int d) {
	/* returns +1 if a/b > c/d, 0 if a/b=c/d, -1 else */
	/* normalise a/b, c/d before using this function */
	long int de;
	
	if (b==0 || d==0)
		return(0);
	
	de = a*d-c*b;
	if (de>0) return(1);
	else if (de<0) return(-1);
	else return(0);
}


/* --- tag stack structure & operations,
needed for tag range detection --- */

long int tagno, this_tagno;

typedef struct {
	long int tagno;
	void *next;
} tagStack;

static tagStack *tagStackTop = NULL;

long int gd_tagStackPop(void) {
	tagStack *p;
	long int res = 0;
	
	p = tagStackTop;
	if (p != NULL) {
		res = p->tagno;
		tagStackTop = (tagStack*) p->next;
		free(p);
	}
	return(res);
}

void gd_tagStackClear(void) {
	while (tagStackTop != NULL) {
		gd_tagStackPop();
	}
}

void gd_tagStackPush(long int tagno) {
	tagStack *p;
	
	p = (tagStack*) malloc(sizeof(tagStack));
	if (p != NULL) {
		p->tagno = tagno;
		p->next = tagStackTop;
		tagStackTop = p;
	}
}


/* -------------------------------------------------
APPLICATION SPECIFIC SECTIONS:

  the following part has to be adapted for the
  application which is to use the GUIDO parser module
------------------------------------------------- */

/* NoteAbility interface */
#include "naguido.h"

/* --- interface variables: --- */

/* rtp auto increase on note append on/off */
int rtp_auto_inc=1;


/* --- state variables: --- */

/* current segment properties: */
long int sg_num_voices = 0; /* voices counter */
long int sg_num_notes = 0; /* notes counter */
long int sg_num_tags = 0; /* tags counter */

/* rel. dur. of current segment: */
long int sg_enum = 0;
long int sg_denom = 1;


/* current sequence (voice) properties: */
long int sq_num_notes = 0;  /* note counter */
long int sq_num_tags = 0;   /* tag counter */
long int sq_max_voices = 0; /* max chord voices counter */

/* rel. time pos within current voice: */
long int rtp_enum = 0;
long int rtp_denom = 1;
/* rel. time pos within current voice before last note: */
long int last_rtp_enum = 0;
long int last_rtp_denom = 1;
/* rel. time pos offset when within chord: */
long int rtp_ch_enum = 0;
long int rtp_ch_denom = 1;

/* current note properties: */
int nt_dotMode=0;	/* number of dots seen */
int nt_enumSet=0;       /* enum of rel.dur explicitely specified? */
int nt_absDurMode=0;    /* absolute duration specified? */

/* root pc, octave and accidentals of current / last note: */
int nt_pc=0;
int nt_oct=1;
int nt_acc=0;

/* rel. dur. of current / last note: */
long int nt_enum=0;
long int nt_denom=1;

/* current chord properties: */
int ch_num_notes=0;	/* number notes in chord */

/* rel. dur. of current chord: */
long int ch_enum=0;
long int ch_denom=1;


/* --- action functions: --- */

int gd_noteName2pc (char *name) {
	int res;
	if ( strcmp(name,"c") == 0
		|| strcmp(name,"do") == 0 
		|| strcmp(name,"ut") == 0 )
		res =  NOTE_C;
	else if (strcmp(name,"cis") == 0 )
		res =  NOTE_CIS;
	else if ( strcmp(name,"d") == 0
		|| strcmp(name,"re") == 0 )
		res =  NOTE_D;
	else if (strcmp(name,"dis") == 0 )
		res =  NOTE_DIS;
	else if ( strcmp(name,"e") == 0
		|| strcmp(name,"mi") == 0 )
		res =  NOTE_E;
	else if ( strcmp(name,"f") == 0
		|| strcmp(name,"fa") == 0 )
		res =  NOTE_F;
	else if (strcmp(name,"fis") == 0 )
		res =  NOTE_FIS;
	else if ( strcmp(name,"g") == 0
		|| strcmp(name,"sol") == 0
		|| strcmp(name,"so") == 0 )
		res =  NOTE_G;
	else if (strcmp(name,"gis") == 0 )
		res =  NOTE_GIS;
	else if ( strcmp(name,"a") == 0
		|| strcmp(name,"la") == 0 )
		res =  NOTE_A;
	else if (strcmp(name,"ais") == 0 )
		res =  NOTE_AIS;
	else if ( strcmp(name,"h") == 0
		|| strcmp(name,"b") == 0
		|| strcmp(name,"si") == 0 
		|| strcmp(name,"ti") == 0 )
		res =  NOTE_H;
	else if (strcmp(name,"_") == 0 
		|| strcmp(name,"rest") == 0)
		res =  REST;
	else if (strcmp(name,"empty") == 0)
		res =  EMPTY;
	else {
		res =  REST;
		ERROR ("Unknown notename, replaced by rest.");
	}
	return(res);
}


void gd_noteInit (char *id) {
	DEBUG(
		printf("note %s (=%i)\n", id, gd_noteName2pc(id));
	)
		nt_pc = gd_noteName2pc(id);
	nt_acc=0;
}

void gd_noteAcc (int n) {
	DEBUG(
		printf("acc %i\n", n);
	)
		nt_acc += n;
}

void gd_noteOct (int n) {
	DEBUG(
		printf("oct %i\n", n);
	)
		nt_oct = n;
}

void gd_noteEnum (long int n) {
	DEBUG(
		printf("enum %li\n", n);
	)
		nt_enum=n;
	nt_denom=1;
	nt_enumSet=1;
	nt_dotMode = 0;
}

void gd_noteDenom (long int n) {
	DEBUG(
		printf("denom %li\n", n);
	)
		nt_denom=n;
	if(!nt_enumSet)
		nt_enum=1;
	nt_dotMode = 0;
}

void gd_noteDot(void) {
	DEBUG(
		printf("dot\n");
	)
		nt_dotMode = 1;
}

void gd_noteDdot(void) {
	DEBUG(
		printf("ddot\n");
	)
		nt_dotMode = 2;
}

void gd_noteAbsDur (long int n) {
	DEBUG(
		printf("absdur %li\n", n);
	)
		nt_enum=n;
	nt_denom=1000;
	nt_dotMode = 0;
	nt_absDurMode = 1;
}

void gd_seqAppendNote (void) {
	long int d,e;
	
	DEBUG(
		printf("app note (rtp=%li/%li)\n", rtp_enum, rtp_denom);
	)
		switch (nt_dotMode) {
	 case 1: e = nt_enum *3; d = nt_denom *2; break;
	 case 2: e = nt_enum *7; d = nt_denom *4; break;
	 default: e=nt_enum; d=nt_denom;
	}
	gd_fracNorm(&e,&d);
	
	if(parse_mode == PARSE_MODE_ALL || parse_mode == PARSE_MODE_PHASE_2)
		na_seqAppendNote(nt_pc,nt_oct,nt_acc,
		nt_enum,nt_denom,nt_dotMode,
		rtp_enum, rtp_denom);
	
	if(rtp_auto_inc) {
		last_rtp_enum = rtp_enum;
		last_rtp_denom = rtp_denom;
		gd_fracAdd(&rtp_enum, &rtp_denom, e,d);
	}
	
	nt_enumSet=0;
	sq_num_notes++;
}


void gd_chordInit(void) {
	DEBUG(
		printf("init chord\n");
	)
		ch_enum = 0;
	ch_denom = 1;
	ch_num_notes = 0;
	
	if(parse_mode == PARSE_MODE_ALL || parse_mode == PARSE_MODE_PHASE_2)
		na_chordInit(rtp_enum, rtp_denom);
}


void gd_chordInitNote(void) {
	DEBUG(
		printf("chord init note\n");
	)
		rtp_ch_enum = 0;
	rtp_ch_denom = 1;
	
	if(parse_mode == PARSE_MODE_ALL || parse_mode == PARSE_MODE_PHASE_2) {
		na_chordInitVoice();
    }
}


void gd_chordAppendNote(void) {
	long int d,e;
	
	DEBUG(
		printf("chord app note\n");
	)
		switch (nt_dotMode) {
	 case 1: e = nt_enum *3; d = nt_denom *2; break;
	 case 2: e = nt_enum *7; d = nt_denom *4; break;
	 default: e=nt_enum; d=nt_denom;
	}
	
	if(parse_mode == PARSE_MODE_ALL || parse_mode == PARSE_MODE_PHASE_2)
		na_seqAppendNote(nt_pc,nt_oct,nt_acc,
		nt_enum,nt_denom,nt_dotMode,
		rtp_enum, rtp_denom);
	
	gd_fracNorm(&e,&d);
	if (gd_fracCmp(e,d, ch_enum, ch_denom) > 0) {
		ch_enum=e;
		ch_denom=d;
	}
	
	rtp_ch_enum = e;
	rtp_ch_denom = d;
	
	nt_enumSet=0;
	
	ch_num_notes++;
}

void gd_seqAppendChord(void) {
	DEBUG(
		printf("app chord (rtp=%li/%li)\n", rtp_enum, rtp_denom);
	)
		sq_num_notes += ch_num_notes;
	if (ch_num_notes > sq_max_voices)
		sq_max_voices = ch_num_notes;
	
	if(parse_mode == PARSE_MODE_ALL || parse_mode == PARSE_MODE_PHASE_2)
		na_seqAppendChord(ch_num_notes,
		nt_enum,nt_denom,nt_dotMode,
		rtp_enum, rtp_denom);
	
	if(rtp_auto_inc) {
		last_rtp_enum = rtp_enum;
		last_rtp_denom = rtp_denom;
		gd_fracAdd(&rtp_enum, &rtp_denom, nt_enum,nt_denom);
	}
	
	ch_num_notes = 0;
	ch_enum = 0;
	ch_denom = 1;
	
	rtp_ch_enum = 0;
	rtp_ch_denom = 1;
}


void gd_seqInit(void) {
	DEBUG(
		printf("init seq\n");
	)
		rtp_enum=0;
	rtp_denom=1;
	
	rtp_ch_enum = 0;
	rtp_ch_denom = 1;
	
	sq_num_notes=0;
	sq_num_tags=0;
	sq_max_voices=1;
	
	nt_oct=1;
	nt_enum=1;
	nt_denom=4;
	nt_dotMode=0;
	nt_enumSet=0;
	nt_absDurMode=0;
	
	rtp_auto_inc=1;
	na_seqInit();
}

void gd_seqExit(void) {
	DEBUG(
		printf("exit seq\n");
	)
	/*
	printf("sequence statistics (voice %li):\n", sg_num_voices+1);
	printf("  num notes = %li\n", sq_num_notes);
	printf("  num tags = %li\n", sq_num_tags);
	printf("  max chord voices = %li\n", sq_max_voices);
	printf("  rel. duration = %li/%li\n", rtp_enum, rtp_denom);
	printf("\n");
	*/
	
	na_seqExit();
}


void gd_segmInit(void) {
	DEBUG(
		printf("init segm\n");
	)
		tagno = 0;
	
	sg_enum = 0;
	sg_denom = 1;
	
	sg_num_voices = 0;
	sg_num_notes = 0;
	sg_num_tags = 0;
	
	na_segmInit();
}

void gd_segmExit(void) {
	DEBUG(
		printf("exit segm\n");
	)
	/*
	printf("segment statistics:\n");
	printf("  num voices = %li\n", sg_num_voices);
	printf("  num notes = %li\n", sg_num_notes);
	printf("  num tags = %li\n", sg_num_tags);
	printf("  rel. duration = %li/%li\n", sg_enum, sg_denom);
	printf("\n");
	*/
	
	na_segmExit();
}

void gd_segmAppendSeq(void) {
	DEBUG(
		printf("app segm\n");
	)
		if (gd_fracCmp(rtp_enum,rtp_denom, sg_enum, sg_denom)>0) {
			sg_enum = rtp_enum;
			sg_denom = rtp_denom;
		}
		
		sg_num_voices++;
		sg_num_notes += sq_num_notes;
		sg_num_tags += sq_num_tags;
}


/* tag handling */

typedef struct {
	char type;
	char* name;
	T_REAL d;
	long l;
	char* s;
	char* unit;
} ARGV;

char *tag;
int argc;
ARGV *argv;


void gd_tagStart(char* id, long int no) {
	int call_na = 0;
	long int e,d;
	
	tagno++;
	DEBUG(
		printf("tag start %s (no=%i, id=%li, rtp=%li/%li)\n",
		id, no, tagno, rtp_enum, rtp_denom);
	)
		
		e = rtp_enum; d = rtp_denom;
	gd_fracAdd(&e,&d, rtp_ch_enum, rtp_ch_denom);
	
	argc = 0;
	argv = NULL;
	switch(parse_mode) {
    case PARSE_MODE_PHASE_1_1:
		call_na = strlist_findStr(&tags11,id);
		break;
    case PARSE_MODE_PHASE_1_3:
		call_na = strlist_findStr(&tags13,id);
		break;
    case PARSE_MODE_PHASE_2:
		call_na = strlist_findStr(&tags2,id);
		break;
    case PARSE_MODE_ALL:
		call_na = 1;
		break;
    }
	if (call_na) {
		gd_tagStackPush(tagno);
		this_tagno = tagno;
		na_tagStart(id, no, tagno, e, d);
    }
	else {
		// tagno -1 signals that tag was ignored
		gd_tagStackPush(-1);
		this_tagno = -1;
    }
}

void gd_tagEnd(void) {
	long int tagno;
	long int e,d;
	
	e = rtp_enum; d = rtp_denom;
	tagno = gd_tagStackPop();
	gd_fracAdd(&e,&d, rtp_ch_enum, rtp_ch_denom);
	DEBUG(
		printf("tag end (id=%li, rtp'=%li/%li)\n",
		tagno, e, d);
	)
		
		if(tagno != -1)
			// tagno -1 signals that tag was ignored
			if (rtp_ch_enum == 0) // if not after a chord note
				na_tagEnd(tagno, e,d, last_rtp_enum,last_rtp_denom);
			else
				na_tagEnd(tagno, e,d, rtp_enum, rtp_denom);
			
			free (tag);
			while (argc--) {
				free (argv[argc].name);
				free (argv[argc].unit);
				if (argv[argc].type == 's')
					free (argv[argc].s);
			}
			free (argv);
			argc = 0;
			argv = NULL;
}


void gd_tagIntArg(long int n)
{
	DEBUG(printf("gd_tagIntArg(n=%li)\n",n);)
		
		argv = (ARGV*)realloc (argv, sizeof (ARGV) * ++argc);
	argv[argc-1].type = 'i';
	argv[argc-1].name = (char*) malloc (sizeof (char) * (strlen("")+1));
	strcpy (argv[argc-1].name, "");
	argv[argc-1].unit = (char*) malloc (sizeof (char) * (strlen("")+1));
	strcpy (argv[argc-1].unit, "");
	argv[argc-1].l = n;
}


void gd_tagFloatArg(T_REAL r)
{
	DEBUG(printf("gd_tagFloatArg(r=%f)\n",r);)
		
		argv = (ARGV*)realloc (argv, sizeof (ARGV) * ++argc);
	argv[argc-1].type = 'f';
	argv[argc-1].name = (char*) malloc (sizeof (char) * (strlen("")+1));
	strcpy (argv[argc-1].name, "");
	argv[argc-1].unit = (char*) malloc (sizeof (char) * (strlen("")+1));
	strcpy (argv[argc-1].unit, "");
	argv[argc-1].d = r;
}


void gd_tagArgUnit(char* unit) {
	DEBUG(printf("gd_tagArgUnit(unit=%s)\n",unit);)
		
		free(argv[argc-1].unit);
	argv[argc-1].unit = (char*) malloc (sizeof (char) * (strlen(unit)+1));
	strcpy (argv[argc-1].unit, unit);
}

void gd_tagStrArg(char *s)
{
	DEBUG(printf("gd_tagStrArg(s=%s)\n",s);)
		
		argv = (ARGV*)realloc (argv, sizeof (ARGV) * ++argc);
	argv[argc-1].type = 's';
	argv[argc-1].s = (char*) malloc (sizeof (char) * (strlen (s) + 1));
	argv[argc-1].name = (char*) malloc (sizeof (char) * (strlen(""))+1);
	strcpy (argv[argc-1].name, "");
	argv[argc-1].unit = (char*) malloc (sizeof (char) * (strlen("")+1));
	strcpy (argv[argc-1].unit, "");
	strcpy (argv[argc-1].s, s);
}

void gd_tagAddArg(char *s) {
	DEBUG( printf("gd_tagAddArg(s=%s)\n",s); )
		free(argv[argc-1].name);
	argv[argc-1].name = (char*) malloc (sizeof (char) * (strlen(s))+1);
	strcpy (argv[argc-1].name, s);
}

void gd_tagAdd(void) {
	DEBUG(
		printf("tag add\n");
	)
		sq_num_tags++;
	if (this_tagno != -1)
		na_tagAdd(this_tagno, argc);
}


void gd_tagRange(void) {
	DEBUG(
		printf("tag range\n");
	)
}


char gd_getTagArgType(int n) {
	if(n <= argc)
		return argv[n-1].type;
	else
		return '-';
}

char* gd_getTagArgName(int n) {
	if(n <= argc)
		return argv[n-1].name;
	else
		return NULL ;
}

long int gd_getTagArgInt (int n) {
	if(n <= argc)
		return argv[n-1].l;
	else
		return 0;
}

T_REAL gd_getTagArgFloat (int n) {
	if(n <= argc)
		return argv[n-1].d;
	else
		return 0.0;
}

char* gd_getTagArgUnit (int n) {
	if(n <= argc)
		return argv[n-1].unit;
	else
		return NULL;
}

char* gd_getTagArgStr (int n) {
	if(n <= argc)
		return argv[n-1].s;
	else
		return NULL;
}

void gd_durIncrOn(void) {
	DEBUG(
		printf("na_durIncrOn()\n");
	)
		rtp_auto_inc=1;
}

void gd_durIncrOff(void) {
	DEBUG(
		printf("na_durIncrOff()\n");
	)
		rtp_auto_inc=0;
}

int gd_error(const char *msg) {
	DEBUG(
		printf("\nERROR: %s (line %li, char %li)\n", msg, lnr,cnr);
	)
		return(na_parseError(lnr,cnr,msg));
}


