/* guido tools - version 0.1 */
/* (c) 1998 by Holger H. Hoos */

/* for use in guido music notation import / export */


#include <stdlib.h>
#include <string.h>

#include "gmntools.h"

/* conversion between units (advanced guido) */
/* note: hs and rl are relative units dependent on
         the context; consequently, they cannot be converted
         using this function - see Advanced GUIDO Spec */
T_REAL gd_convertUnits(T_REAL fromValue,
                       T_STRING fromUnit, T_STRING toUnit) {

  /* conversion required? */
  if(strcmp(fromUnit,toUnit)==0)
    return(fromValue);

  /* normalise to mm ('cause we are metric!) */
  if(strcmp(fromUnit,"cm")==0)
    fromValue *= 10.0;
  else if(strcmp(fromUnit,"m")==0)
    fromValue *= 1000.0;
  else if(strcmp(fromUnit,"in")==0)
    fromValue *= 25.4;
  else if(strcmp(fromUnit,"pt")==0)
    fromValue *= 25.4/72.27;
  else if(strcmp(fromUnit,"pc")==0)
    fromValue *= 25.4/72.27*12.0;

  /* convert from mm to toUnit */
  if(strcmp(toUnit,"mm")==0)
    return(fromValue);
  if(strcmp(toUnit,"cm")==0)
    return(fromValue / 10.0);
  else if(strcmp(toUnit,"m")==0)
    return(fromValue / 1000.0);
  else if(strcmp(toUnit,"in")==0)
    return(fromValue / 25.4);
  else if(strcmp(toUnit,"pt")==0)
    return(fromValue / 25.4*72.27);
  else if(strcmp(toUnit,"pc")==0)
    return(fromValue / 25.4*72.27/12.0);
  else
    return(REAL_INVALID);
  }



/* test code - for testing purposes only */
/*

#include<stdio.h>

int main() {
  printf("%lf %lf \n", 1.23, gd_convertUnits(1.23, "m", "mm"));
  return(0);
  }

*/

