/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
*  lgtagarg.h
*
*/
#ifndef __lgtagarg_h__
#define __lgtagarg_h__


// declartations of all tag related classes

using namespace std; 
#include <string>
#include <sstream>
using namespace std; 

#include "lgevent.h"

#include "lgvisitor.h"

//!  generic tag argument without value
class lgTagArg : public lgObject
{
	string nameI;
	    
protected:
	/// unit string, is "" for stringTagArgs
	string unitI;
    
public :
	virtual string toString( lgVoice *seq = NULL );

    lgTagArg( 	/// argument name
    			const char *na,
    			/// argument unit
				const char *un);
    virtual ~lgTagArg( void );
	
	
    virtual string valStr( void )
    { return string(""); };
    virtual int valInt( void )
    { return 0; };
    virtual double valFloat( void )
    { return 0; };
	
	virtual string unit( void )
	{ return unitI; };
	
	/// argument name, might be "" if unnamed
    const string name( void )
    {return nameI; };
    	
};

//! string lgTagArg argument
class lgStrTagArg : public lgTagArg
{
    string valI;
	
public :
	virtual string toString( lgVoice *seq = NULL );
    lgStrTagArg( /// argument name
    			 const char *na,
    			 /// argument value
				const char *v);
    virtual ~lgStrTagArg( void );
	
    virtual string valStr( void )
    {return valI; };
    
    virtual int valInt( void )
    { return atoi(valI.c_str()); };
    virtual double valFloat( void )
    { return atof(valI.c_str()); };
    
    
	virtual void setValStr( const char * val )
    { valI = val; };

	
};

//! integer lgTagArg argument
class lgIntTagArg : public lgTagArg
{
    int valI;
	
public :
	virtual string toString( lgVoice *seq = NULL );
	lgIntTagArg( /// argument name, might be ""
				 const char *na,
				 /// argument value
				int v,
				const char *unit = "");
	
    virtual int valInt( void )
    {return valI; };

    virtual double valFloat( void )
    { return valI; };
    
    virtual string valStr( void )
    { ostringstream res;
      res << valI;
      return res.str();	 };
    
    virtual void setValInt( int val )
    { valI = val; };
};

//! double lgTagArg argument
class lgFloatTagArg : public lgTagArg
{
    double valI;
public :
	virtual string toString( lgVoice *seq = NULL);

    lgFloatTagArg( 	/// argument name
    				const char *na,
    				/// argument value
					double v,
					const char *unit = "");
	
    virtual double valFloat( void )
    { return valI; };
    virtual string valStr( void )
    {  ostringstream res;
      res << valI;
      return res.str();	 };
    virtual int valInt( void )
    { return (int)(valI+0.5); };
    
    virtual void setValFloat( double val )
    { valI = val; };
};


#endif
