/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 *  lgtagarg.cpp
 *
 */

#include <sstream>
#include "lgtagarg.h"
#include "lgsequence.h"


lgTagArg::lgTagArg(const char *na,
                       const char *unit)
{
    if(na)
    {
		nameI = string( na );
    }

    if( unit )
    {
		unitI = unit;
    }
    nextI = NULL;
}

lgTagArg::~lgTagArg( void )
{
}


string lgTagArg::toString( lgVoice * )
{
	string res;
	if( nameI != "" )
	{
			res = nameI;
			res += "=";
	}

	return res;    
}

//-----------------------------------------------------

lgStrTagArg::lgStrTagArg( const char *na,
                         const char *v) : lgTagArg(na, NULL)
{
    if( v )
    {
		valI = v;
    }
}


lgStrTagArg::~lgStrTagArg( void )
{
}
string lgStrTagArg::toString( lgVoice *v )
{
	string s = lgTagArg::toString(v);
	s +="\"";
	s += valI;
	s += "\"";
	return s;
}
//-----------------------------------------------------

lgIntTagArg::lgIntTagArg( const char *na,
                    int v,
                    const char *unit ) : lgTagArg(na, unit)
{
    valI = v;
}

string lgIntTagArg::toString( lgVoice *v)
{
	ostringstream s;
	s << lgTagArg::toString(v);
	s << valI;
	s << unitI;
	return s.str();
}
//-----------------------------------------------------

lgFloatTagArg::lgFloatTagArg( const char *na,
                    double v,
                    const char *unit ) : lgTagArg(na, unit)
{
    valI = v;
}

string lgFloatTagArg::toString( lgVoice *v)
{
	ostringstream s;
	s.setf(ios::fixed, ios::floatfield);
	s << lgTagArg::toString(v); // the name
	s << valI;
	s << unitI;
	return s.str();
}

//------------------------------------------------------


