/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
*  lgtag.h
*
*/

#ifndef __lgtag_h__
#define __lgtag_h__


#include <sstream>
#include <string>
using namespace std; 

#include "lgtagarg.h"
#include "lgevent.h"
#include "lgvisitor.h"
#include "lgfactory.h"

/// values returned by lgTag::tagType( void )
enum  lgTagTypes {
/// a tag without a range
noRangeType,
/// a tag with a (...) range
rangeType,
/// a ")" tag
endBracketType,
/// a \beginXXX tag
beginType,
/// a \endXXX tag
endType,
/// a (* tag
remarkBegin,
/// a *) tag
remarkEnd
};

//! GUIDO tag with name and a list of arguments given as lgTagArg
class lgTag : public lgObject
{
	friend class lgChord;
	friend class lgVoice;
	
	/// tag name including "\"
    string nameI;	
	/// unique id given by parser, end range tags have -1 * startrange->id
    long int idI;	
	
	/// list of arguments
    lgTagArg   *argsI;	
	
    /// pointer to previous event, tag-range starts AFTER prevEvI, is NULL if tag starts before first note of sequence!
    lgEvent    *prevEvI;
	
	/// pointer to close range tag ")" or \endXXX
	lgTag *rangeEnd;	
public:
	
	// return the type of tag (noRange, range, begin, end, remark, )
	int tagType( void );

	/// get parameter value as a string, return 0 if parameter does not exist
	int getParamChar( /// parameter name (might be NULL)
						const char *pname,
						/// default position of paramter 1...n
						int defPos,
						/// value
						string &value,
						/// unit if available
						string &unit );
						
	/// get parameter value as an int, return 0 if parameter does not exist
	int getParamInt( /// parameter name (might be NULL)
						const char *pname,
						/// default position of paramter, 1...n
						int defPos,
						/// value
						int &value,
						/// unit if available
						string &unit );
						
	/// get parameter value as a double, return 0 if parameter does not exist
	int getParamFloat( /// parameter name (might be NULL)
						const char *pname,
						/// default position of paramter, 1...n
						int defPos,
						/// value
						double &value,
						/// unit if available
						string &unit );

    /// prototype, not used at the moment
    void accept( stringVisitor v )
    {
        v.visit(this);
    };
    virtual string toString( lgVoice *v = NULL );
    
	// tag name including "\", tags can be converted to remarkTags by using "(*" as tagname
	string name( void );
	void setName( /// neq name of this
				  const char *str,
				  /// name of end range tag	
				  const char *str2 = NULL)
	{
		if( str )
			nameI = str;
		else
			nameI = "";
			
		if( str2 &&
		    rangeEnd )
		{
			rangeEnd->setName( str2, NULL );
		}
	}

	/// create a new tag
	lgTag( /// unique id
			long int id,
			/// previous event -> time position of tag, if timepos == 0 -> pEv == lgVoice
			lgEvent *pEv,
			const char *nameI);
	
    virtual ~lgTag( void );
	
	/// unique tag id generated by the parser or given by user
    long int id( void )
    {return idI;};

    /// number of args
    int cArgs( void );	
    lgTagArg *firstArg( void ); 
	/// search forargument by name, if not exists and defPos > -1 search at defPos
	lgTagArg *findArg(const char *name,
					/// 1...n 
					 int defPos = 0 );
	
	/// get tag arg 1...n
	lgTagArg *getArg( /// 1...n
						int id );
	
	
	
    /// add argument
    void addArg(lgTagArg *pa);

	/// remove arguemnt
	void removeArg( lgTagArg * pa);
	
    /// get event before tag, points to lgSequence at begin of sequence!!
    lgEvent *pEvent( void )
    {return prevEvI; };
    
    /// get first event in range
	lgEvent * firstInRange( void );
	
	/// get last event in range
	lgEvent * lastInRange( void );
    

	/// set a range by attavhing an ")" or \endXXX tag
    void setRange( lgTag *ta );

	/// return endRange tag ")" or "\\tagEnd"    
    lgTag *endRange( void )
    {
    	return rangeEnd;
    }
	
    /// increment rangeStack of last event in range
    // virtual void pushRangeStack( void );
	
    /// 1 if explicite range has been set
    char hasRange( void );
    
	 /// true if hasRange and no notes inside!
    char emptyRange( void );
    /// split \tag(...) into \tagBegin \tagEnd if tag has a range, and return 1 if range has been converted
	int splitRange( void );
	
	

    /// == prevI->Attack + prevEv->Dur
    virtual lgFrac pos( void );
    //! result < 0 if no range, please see readme.txt for issues
    lgFrac endPos( void );
}; 




#endif
