/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 *  lgsegment.h
 *
 */

/// Todo: add parse-error function to lgSegment?
/// Todo: add visitor concept
/// Todo: replace lgObject, lgEvent and lgVoice by containers ?


#ifndef __lgsegment_h__
#define __lgsegment_h__

#include "lgchord.h"
#include "lgsequence.h"
#include "lgfactory.h"

/// if USE_GUIDO_PARSER is undefined a lgVersion without parser functionality can be compiled
#define USE_GUIDO_PARSER

//! GUIDO Segment based on lgChord with parsing support
class lgSegment : public lgChord
{
	//! curPointers for parsing
    lgSequence *curSequence;
    lgChord    *curChord;
    lgEvent    *curEvent;
    lgTag      *curTag;
	lgVoice	   *curChordVoice;
protected:
		

public:
	/// ptr to the factory object
	lgFactory  *factory;
    lgSegment( 	lgFactory *fy );

#ifdef USE_GUIDO_PARSER
	/// result: 0 == ok, 1 == parse error
	int parseGMNFile(FILE *file); 
	/// result: 0 == ok, 1 == parse error
    int parseGMNFile(const char *filename);
	/// result: 0 == ok, 1 == parse error
	int parseString( char *str );
	/// result: 0 == ok, 1 == parse error
	int parseString( string str )
    {
        return parseString(str.c_str() );
    };
#endif

    virtual ~lgSegment( void );
    /// append event in curSequence OR curChord!!!
    virtual void appendEvent( lgEvent *ev);

    /// create a new virtual lgRest event and append
    lgRest  *appendRest( long int durN,
                      long int durD,
                     int dots,
                      long int durPosN,
                      long int durPosD )
    {
        lgRest *temp;
        temp = factory->newRest(durN,
                              durD,
                              dots,
                              durPosN,
                       durPosD);

        appendEvent(temp );
        return temp;
    };

    /// create a new virtual lgEmpty and append
    void appendEmpty( long int durN,
                 long int durD,
                 int dots,
                 long int durPosN,
                 long int durPosD )
    {
        appendEvent( factory->newEmpty(durN,
                              durD,
                              dots,
                              durPosN,
                              durPosD) );
    };

    /// create a new virtual lgNote and append
    lgNote *appendNote( int pc,
                     int oct,
                     int acc,
                     long int durN,
                     long int durD,
                     int dots,
                     long int durPosN,
                     long int durPosD )
    {
        lgNote *temp;
        temp =  factory->newNote( pc,
                              oct,
                              acc,
                              durN,
                              durD,
                              dots,
                              durPosN,
                         durPosD);

            appendEvent(temp);
            return temp;
    };

    
    
    /// append chord in curSequence, if ch == NULL -> close current chord, return == appended chord!
    lgChord *appendChord( lgChord *ch);

    /// append tag in curSequence
    void insertTag( lgTag *tag);
    /// create a new tag and append
    /// overwrite this function for tag semantics check!
    virtual lgTag *appendTag(long int tagno,
                             const char *tagname );
                             
    /// create a new chord in curSequence
    lgChord *initChord( long int posNum, long int posDenom );
    /// create a new voice in curChord
    void initChordVoice( void );
    /// close curVoice
    void exitChordVoice( void );
    
    virtual lgSequence *appendSequence( lgSequence *seq = NULL);

    void exitSequence( void );
    
    void closeTag( long int id );
    
    lgSequence *firstSequence( void )
    {
        curSequence = dynamic_cast<lgSequence *>(firstVoice());
        return curSequence;
    };
    lgSequence *nextSequence( void )
    {
        if( curSequence )
            curSequence = dynamic_cast<lgSequence *>(curSequence->next());
        return curSequence;
    };

    virtual string toString( lgVoice *callingSeq = NULL )
    {
        return lgChord::toString( callingSeq );
    }
	
    virtual void write( FILE *out, lgVoice *v = NULL )
	{
		v = NULL;
		lgChord::write( out, NULL );
	}
	
	virtual void writeFile( const char *fname )
	{
		if( !fname )
			return;
		FILE *out;
		out = fopen(fname,"wt");
		if( !out )
			return;
		write(out);
		fclose(out);
		return;
	}
	// ls: einzeln Segment kann mehre Sequencen besitzen, die duch ID durchnummeriert werden. 
	lgSequence* searchByID(int n)
	{
		if(!n) return NULL;
		else
		{
			lgSequence *tmp=firstSequence();
			while(tmp && tmp->getID()<n) tmp=nextSequence();
			if(!tmp) return NULL;
			else if(tmp->getID()==n) return tmp;
			else return NULL;
		}
	};

}; 


#endif