/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/*
 *  lgsegment.cpp
 *
 */

#include "lgsequence.h"
#include "lgsegment.h"
#include "lgfactory.h"



lgSegment * curSegment; // used in parser
lgTag * curTag;


// if parser functions are not needed, undef next line
#ifdef USE_GUIDO_PARSER

#include "naguido.h"
/*! parse a .gmn file and fille the data structure
	result:		0 = ok
				1 = error
*/
int lgSegment::parseGMNFile(const char *filename)
{
    curSegment = dynamic_cast<lgSegment *>(this);
    /// pointers for parsing
    curSequence = NULL;
    curChord = NULL;
    curEvent = NULL;
    curTag	 = NULL;
    curChordVoice = NULL;
    
    return na_parseGMNFile(filename);
};
#endif



lgSegment::lgSegment( lgFactory *fy) : lgChord(0,1 )
{
    curEvent = NULL;
    curSequence = NULL;
    curChord = NULL;
	curChordVoice = NULL;
    curTag = NULL;
	factory = fy;    
}

/// append a new sequence and store in curSequence, if seq == NULL a sequence will be created
lgSequence * lgSegment::appendSequence( lgSequence *seq )
{
	if( !seq )
		seq = factory->newSequence(0,0);

	// use lgChord function
	appendVoice( seq );

	// current ptr for parsing
	curSequence = seq;
	curChord = NULL;
	curEvent = NULL; 
	curChordVoice = NULL;
	curTag = NULL;
    return seq;
}


//! append event in current sequence or in current chordVoice! Each chord voice must contain exactly one event!
void lgSegment::appendEvent( lgEvent *ev )
{
	/// we are inside a chord
	if( curChord )
	{
		//! create new voice in chord!
		curChordVoice->appendEvent(ev); 
	}
	else
	{
		curSequence->appendEvent(ev);
	}
	curEvent = ev;
}

/// leave, close the current sequence if parsing a ']'
void lgSegment::exitSequence( void )
{
	curSequence = NULL;
	curEvent = NULL;
	curChord = NULL;
	curTag = NULL;
}

//! create a new voice in curChord, call initChord before using this function!!!
void lgSegment::initChordVoice( void )
{
	if( curChord )
	{
		lgVoice *temp = factory->newVoice(0,0);
		curChord->appendVoice(temp);
		curChordVoice = temp;
	}
	else
	{
		// error, because no chord was initialised before!
	}
}
//! create a new chord
lgChord * lgSegment::initChord(long int posNum, long int posDenom )
{
	lgChord *temp = factory->newChord( posNum, posDenom );
	curChord = temp;
	curChordVoice = NULL;
    return temp;
}

//! if ch =0 NULL chord is completely parsed -> append curChord, else append ch!
lgChord *lgSegment::appendChord( lgChord * ch )
{
	if( !ch ) // close current chord
		ch = curChord;
	curSequence->appendEvent( ch );
	curChord = NULL;
	curEvent = ch;
	curChordVoice = NULL;
	return ch;
}
//! appand tag in curSequence tag list or curChordVoice tag list!
void lgSegment::insertTag(lgTag *tag )
{
	/// tag might be NULLL if it should be ignored!
	if( !tag )
		return;
	// if tag->pEv == NULL this will be set to the last event of curVoice/curSequence during insertTag
	if( curChordVoice )
		curChordVoice->insertTag(tag );
	else
        curSequence->insertTag(tag);
}

/// append a tag to curSequence->[curChordVoice]
lgTag *lgSegment::appendTag(long int tagno,
                         	const char *tagname )
{
    lgTag *temp = factory->newTag(tagno, NULL, tagname);
    /// the curVoice will set the temp->pEv to the last event of it's events list
    insertTag( temp );
    return temp;
}


/// close a tagrange opend by the parser/user 
void lgSegment::closeTag( long id )
{
	lgTag *temp = findTag(id);
	if( temp )
	{
		if( curEvent &&
			temp->pEvent() != curEvent )
		{
        	/// create a endBracket tag
        	lgTag *endTag = factory->newTag(-id,
                                 curEvent,
                                 ")" );
            /// pointers will be corss linked between begin and end
        	temp->setRange(endTag);
        	/// append tag in curSequence[->curChordVoice]
        	insertTag(endTag);
        } // if
	}
	else
	{
		// error, tag could not be found
	}
}
lgSegment::~lgSegment( void )
{
	// do only ~lgChord
		delete factory;
}



