/*
	leanGUIDO class library
	Copyright (C) 2003  Juergen Kilian, Holger H. Hoos, SALIERI Project

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.

	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/* lgguido.cpp - application specific adaption of naguido.cpp of the GUIDO parser-kit */

#include <stdio.h>
#include "naguido.h"


int na_parseGMNFileMode(const char* filename, int mode) 
{
DEBUG(
  printf("parsing file '%s', mode %i ...\n", filename, mode);
)
  gd_init();
  int res = gd_parse(filename, mode);
  gd_exit();
  return(res);
}

int na_parseGMNFile(const char* filename) 
{
DEBUG(
  printf("parsing file '%s' ...\n", filename);
)
  gd_init();
  int res = gd_parse(filename, PARSE_MODE_ALL);
  gd_exit();
  return(res);
}


char na_getTagArgType(int n) 
{
  return(gd_getTagArgType(n));
}

char* na_getTagArgName(int n) 
{
  return(gd_getTagArgName(n));
}

long int na_getTagArgInt(int n) 
{
  return(gd_getTagArgInt(n));
}

T_REAL na_getTagArgFloat(int n) 
{
  return(gd_getTagArgFloat(n));
}

char* na_getTagArgUnit(int n) 
{
  return(gd_getTagArgUnit(n));
 }

char* na_getTagArgStr(int n) 
{
  return(gd_getTagArgStr(n));
}



/* -------------------------------------------------
	APPLICATION SPECIFIC SECTIONS:

	the following part has to be adapted for the
	application which is to use the GUIDO parser module
	------------------------------------------------- */
#include "lgsegment.h"
#include "lgchord.h"

extern lgSegment *curSegment;
extern lgTag *curTag;

/*
extern lgSequence *curSequence;
extern lgChord *curChord;
extern lgEvent *curEvent;
*/
void na_segmInit()
{
    /// std call
    if( !curSegment )
	{
        curSegment = new lgSegment( new lgFactory() );
	}
    else
    {
        // do nothing, call was from lgSegment itself!
    }
}

void na_segmExit() {
DEBUG(
	printf("na_segmExit()\n");
      )
//    curSegment = NULL;
}

void na_seqInit() {
//	curEvent = NULL;
    //curSequence = new lgSequence();

    //! if no current segment, create one
    if( !curSegment )
		na_segmInit();

    if( curSegment )
        curSegment->appendSequence(); //! create an empty seq
	}

void na_seqExit() {
    DEBUG(
	printf("na_seqExit()\n");
          )
	if( curSegment )
		curSegment->exitSequence();

//    curSequence = NULL;
//	curEvent = NULL;
}

void na_seqAppendNote( int pc, int oct, int acc, long int durN, long int durD, int dots,
		long int durPosN, long int durPosD){
                
//  lgEvent *note;
    if( pc == REST )
        curSegment->appendRest( durN, durD, dots, durPosN, durPosD ); 
        //        note = new lgRest( durN, durD, dots, durPosN, durPosD );
    else if (pc == EMPTY)
        curSegment->appendEmpty( durN, durD, dots, durPosN, durPosD ); 
//        note = new lgEmpty( durN, durD, dots, durPosN, durPosD );
    else
        curSegment->appendNote( pc, oct, acc, durN, durD, dots, durPosN, durPosD );
//        note = new lgNote( pc, oct, acc, durN, durD, dots, durPosN, durPosD );

//    curSegment->appendEvent( note );
}

void na_chordInitVoice( void )
{
	curSegment->initChordVoice();
}

/*
 void na_chordInitNote(void )
{
}
*/

void na_chordInit(long int durPosN, long int durPosD) 
{
	// open a new chord, all following tags, notes, ... will be added to the new chord 
	curSegment->initChord(durPosN, durPosD );
}

void na_seqAppendChord(int voices, long int durN, long int durD, int dots,
    long int durPosN, long int durPosD) 
{
    /// close the current chord
    curSegment->appendChord( NULL );
}


void na_tagStart(char* s, long int no, long int tagno, long int durPosN, long int durPosD) 
{
//    curTag = new lgTag(tagno, NULL, s);
//    curSegment->appendTag( curTag );
    curTag = curSegment->appendTag(tagno, s);
}

void na_tagEnd(long int tagno, long int durPosN, long int durPosD, long int beforeDurPosN, long int beforeDurPosD) 
{
	curSegment->closeTag( tagno );
	/*
    curSequence->closeTag( tagno,
                          curEvent );
						  */
}


/* obsolete from here ... */
void na_tagIntArg(long int n) {
	printf("na_tagIntArg(n=%li)\n",n);
	}

void na_tagFloatArg(T_REAL r) {
	printf("na_tagIntArg(r=%f)\n",r);
	}

void na_tagStrArg(char *s) {
	printf("na_tagStrArg(s=\"%s\")\n",s);
	}
/* ... to here. */


void na_tagAdd(long int tagno, int nargs) 
{
    if( !curTag )
    {
        printf("Ignored tag arg!\n");
        return;
    }
// 	printf("na_tagAdd(tagno=%li, nargs=%i)\n", tagno, nargs);
  	if (nargs > 0) 
  	{
//    printf("  tag parameters:\n");
  		int n;
	    for (n=1; n<=nargs; n++) 
	    {
		    lgTagArg *tagArg = NULL;
//  	    printf("  #%i: na_getTagArgName(%i)=\"%s\"  ",
//                        n, n, na_getTagArgName(n));
      		switch (na_getTagArgType(n)) 
      		{
		        case 'i': tagArg = new lgIntTagArg(
		                            na_getTagArgName(n),
		                            na_getTagArgInt(n),
		                            na_getTagArgUnit(n) );
		                  break;
		        case 'f': tagArg = new lgFloatTagArg(
		                            na_getTagArgName(n),
		                            na_getTagArgFloat(n),
		                            na_getTagArgUnit(n) );
		                  break;
		        case 's': tagArg = new lgStrTagArg(
		                            na_getTagArgName(n),
		                            na_getTagArgStr(n));
		                  break;
		        default: printf("    invalid tag arg type!! na_getTagArgType(%i)=%c\n",
		                        n, na_getTagArgType(n));
        	} // switch
        	if( tagArg )
            	curTag->addArg( tagArg );
      } // for
	} // if
}

int na_parseError(long int lnr, long int cnr, const char *msg) {
 	printf("\nERROR: %s (line %li, char %li)\n", msg, lnr,cnr);
    return 0;
}


